/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.tiles;

import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.AutomationStackHandler;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.InventoryTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public abstract class ABaseInventoryTile
extends ABaseTile
implements InventoryTile {
    private CustomStackHandler input;
    private CustomStackHandler output;
    private AutomationStackHandler automationInput;
    private AutomationStackHandler automationOutput;
    private CombinedInvWrapper combinedInv;
    protected LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.combinedInv);

    public ABaseInventoryTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.input = this.initInput();
        this.output = this.initOutput();
        this.automationInput = this.initAutomationInput((IItemHandlerModifiable)this.input);
        this.automationOutput = this.initAutomationOutput((IItemHandlerModifiable)this.output);
        this.combinedInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationOutput});
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.input.deserializeNBT(compound.m_128469_("input"));
        this.output.deserializeNBT(compound.m_128469_("output"));
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("input", (Tag)this.input.serializeNBT());
        compound.m_128365_("output", (Tag)this.output.serializeNBT());
    }

    @Override
    public LazyOptional<IItemHandler> getExternalInventory() {
        return this.inventoryHolder;
    }

    @Override
    public CombinedInvWrapper getAutomationInventory() {
        return this.combinedInv;
    }

    @Override
    public CustomStackHandler getInput() {
        return this.input;
    }

    @Override
    public CustomStackHandler getOutput() {
        return this.output;
    }
}

